/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <stdio.h>             
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <signal.h>
#include "DCSApi.h"
#include "PMApi.h"

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int set_dpst=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-dpst", argv[i]) == 0 && i < argc - 1 )
		{
			i++;
			set_dpst = atoi(argv[i]);
			printf("set_dpst=%d\n",set_dpst);
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler(ret);

	DCS_DPST  dpstlevel;

	switch (set_dpst)
	{
	case 0:
		ret=DCS_SetDPSTLevel(HIGHEST_POWER_SAVING);
		DCS_ReturnValue_handler( ret);
		printf("*** Set DPST level HIGHEST_POWER_SAVING, press any key to continue\n");
		scanf("%c",&c0);

		ret=DCS_GetDPSTLevel(&dpstlevel);
		DCS_ReturnValue_handler( ret);
		printf(" dpst level is set as HIGHEST_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		
		break;
	case 1:
		ret=DCS_SetDPSTLevel(MEDIUM_POWER_SAVING);
		DCS_ReturnValue_handler( ret);
		printf("*** Set DPST level MEDIUM_POWER_SAVING, press any key to continue\n");
		scanf("%c",&c0);

		ret=DCS_GetDPSTLevel(&dpstlevel);
		DCS_ReturnValue_handler(ret);
		printf(" dpst level is set as MEDIUM_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
	
		break;
	case 2:
		ret=DCS_SetDPSTLevel(LOWER_POWER_SAVING);
		DCS_ReturnValue_handler( ret);
		printf("*** Set DPST level LOWER_POWER_SAVING, press any key to continue\n");
		scanf("%c",&c0);

		ret=DCS_GetDPSTLevel(&dpstlevel);
		DCS_ReturnValue_handler( ret);
		printf(" dpst level is set as LOWER_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);

		break;
	
	case 3:
		ret=DCS_SetDPSTLevel(DISABLED_POWER_SAVING);
		DCS_ReturnValue_handler( ret);
		printf("*** Set DPST level DISABLED_POWER_SAVING, press any key to continue\n");
		scanf("%c",&c0);

		ret=DCS_GetDPSTLevel(&dpstlevel);
		DCS_ReturnValue_handler( ret);
		printf(" dpst level is set as DISABLED_POWER_SAVING and get the dpst level  is: 0x%x\n", dpstlevel);
		
		break;
	default:
		break;
	}

	/*uninitialize the DCS*/
	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler( ret);

	return 0;
}

